sap.ui.define([
	"sap/ui/core/mvc/Controller",
	"sap/ui/model/json/JSONModel",
	"com/nbx/PDFViewer/Example/Dynamic/PdfViewerLoader",
	"sap/base/Log"
], function (
	Controller,
	JSONModel,
	PdfViewerLoader,
	Log
) {
	"use strict";

	const PageController = Controller.extend("com.nbx.PDFViewer.Example.Dynamic.Page", {
		onInit: function () {
			this.byId("idSegmentedButton").setWidth("300px");
			const oModel = new JSONModel({
				Source: sap.ui.require.toUrl("com/nbx/PDFViewer/Example/Dynamic/Example.pdf"),
				Title: "Nubexx PDFViewer - Example Dynamic control loading"
			});

			this.getView().setModel(oModel);
			this._pdfViewer = this.byId("idPDFViewer");
			this._updatePdfViewer("nbx");
		},

		_updatePdfViewer: function(pdfViewerType) {
			PdfViewerLoader.create(pdfViewerType).then(function(modules) {
				const PDFViewer = modules.PdfViewer;
				const oNewPdfViewer = new PDFViewer();

				if (pdfViewerType === "nbx") {
					const aPdfViewerOptions = [
						new modules.Option({ name: "allowContextMenu", value: true }),
						new modules.Option({ name: "toolbarShowSignedFlag", value: true })
					];
					aPdfViewerOptions.forEach(function(pdfViewerOption){
						oNewPdfViewer.addAggregation("pdfViewerOptions", pdfViewerOption);
					});
				}

				PdfViewerLoader.replaceControl(this._pdfViewer, oNewPdfViewer);
				this._pdfViewer = oNewPdfViewer;
			}.bind(this)).catch(function(error) {
				Log.error(error);
			});
		},

		onSegmentedButtonSelectionChange: function (event) {
			const sPdfViewerType = event.getParameter("item").getKey();
			this._updatePdfViewer(sPdfViewerType);
		}
	});

	return PageController;
});
