sap.ui.define([
	"sap/ui/core/mvc/Controller",
	"sap/ui/model/json/JSONModel"
], function (
	Controller,
	JSONModel
) {
	"use strict";

	const PageController = Controller.extend("com.nbx.PDFViewer.Example.Simple.Page", {
		onInit: function () {
			this._sValidPath = sap.ui.require.toUrl("com/nbx/PDFViewer/Example/Simple/Example.pdf");

			this._oModel = new JSONModel({
				Source: this._sValidPath,
				Title: "Nubexx PDFViewer - Example Simple",
				Height: "100%"
			});

			const oView = this.getView();
			oView.setModel(this._oModel);

			this._oPdfViewer = oView.byId("idPDFViewer");
			this._oPdfViewer.setShowDownloadButton(false);
		},

		onCorrectPathClick: function () {
			this._oModel.setProperty("/Source", this._sValidPath);
		},

		onIncorrectPathClick: function () {
			this._oModel.setProperty("/Source", "com/nbx/PDFViewer/Example/Simple/nonexisting.pdf");
		},

		onTogglePrintButton: function () {
			this._oPdfViewer.setShowPrintButton(
				!this._oPdfViewer.getShowPrintButton()
			);
		},

		onToggleDownloadButton: function () {
			this._oPdfViewer.setShowDownloadButton(
				!this._oPdfViewer.getShowDownloadButton()
			);
		}
	});

	return PageController;
});
