sap.ui.define([
	"sap/ui/core/mvc/Controller",
	"sap/ui/model/json/JSONModel"
], function (
	Controller,
	JSONModel
) {
	"use strict";

	const PageController = Controller.extend("com.nbx.PDFViewer.Example.Watermark.Page", {
		onInit: function () {
			this._oModel = new JSONModel({
				Source: sap.ui.require.toUrl("com/nbx/PDFViewer/Example/Watermark/Example.pdf"),
				WatermarkImage: "/Example.svg",
				WatermarkText: "For internal\nuse only",
				Title: "Nubexx PDFViewer - Example Watermark",
				ShowWatermark: true
			});

			const oView = this.getView();
			oView.setModel(this._oModel);

			this._oPdfViewer = oView.byId("idPDFViewer");
		},

		onToggleWatermark: function () {
			this._oPdfViewer.setShowWatermark(
				!this._oPdfViewer.getShowWatermark()
			);
		}
	});

	return PageController;
});
